'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up (queryInterface, Sequelize) {
    await queryInterface.addColumn('videos', 'uploadTime', {
      type: Sequelize.DATE,
      allowNull: true,
    });
    await queryInterface.addColumn('videos', 'enableCaptions', {
      defaultValue: false,
      type: Sequelize.BOOLEAN,
      allowNull: true,
    });
  },

  async down (queryInterface, Sequelize) {
    await queryInterface.removeColumn('videos', 'uploadTime');
    await queryInterface.removeColumn('videos', 'enableCaptions');
  }
};
