const GoogleAuthService = require('../services/googleAuthService');
const logger = require('../utils/logger');

class AuthController {
    async getGoogleAuthUrl(req, res) {
        try {
            const authUrl = GoogleAuthService.getAuthUrl();
            res.json({ authUrl });
        } catch (error) {
            logger.error(`Error generating Google Auth URL: ${error}`);
            res.status(500).json({ error: 'Failed to generate Google Auth URL' });
        }
    }

    async handleGoogleCallback(req, res) {
        try {
            const { code } = req.query;
            if (!code) {
                throw new Error('Authorization code is missing.');
            }

            const jwtToken = await GoogleAuthService.handleCallback(code);


            res.redirect(`${process.env.FRONTEND_URL}/auth/success?token=${jwtToken}`);
        } catch (error) {
            logger.error(`Error handling Google OAuth callback: ${error}`);
            res.redirect(`${process.env.FRONTEND_URL}/auth/error?message=${encodeURIComponent(error.message)}`);
        }
    }


}

module.exports = new AuthController();