const Queue = require('bull');
require('dotenv').config();
const VideoController = require('../controllers/videoController');
const Redis = require('ioredis');
const logger = require('../utils/logger');

const videoQueue = new Queue('video-generation', {
    redis: {
        host: process.env.REDIS_HOST,
        port: process.env.REDIS_PORT,
        password: process.env.REDIS_PASS,
        maxRetriesPerRequest: null,
        enableReadyCheck: false,
    },
});

videoQueue.process('video-generation', async (job) => {
    try {
        logger.info(`Processing job ${job.id}`);

        logger.info(`Job Data: ${JSON.stringify(job.data, null, 2)}`);

        await VideoController.processVideoGenerationJob(job);

        logger.info(`Job ${job.id} completed`);
    } catch (error) {
        logger.error(`Job ${job.id} failed: ${error.message}`);
        throw error;
    }
});

videoQueue.on('error', (error) => {
    logger.error(`Queue Error: ${error.message}`);
});

videoQueue.on('failed', (job, err) => {
    logger.error(`Job ${job.id} failed with error: ${err.message}`);
});

videoQueue.on('completed', (job) => {
    logger.info(`Job ${job.id} successfully completed`);
});

logger.info('Worker is listening for jobs...');
