const WebSocket = require('ws');

class WebSocketService {
    constructor() {
        this.wss = new WebSocket.Server({ port: 8080 });
        this.clients = new Set();
        
        this.wss.on('connection', (ws) => {
            this.clients.add(ws);
            ws.on('close', () => this.clients.delete(ws));
        });
    }

    notifyVideoUpdate(userId, message) {
        for (const client of this.clients) {
            // Send the message to the client who should receive it (filter by userId or session)
            if (client.userId === userId) {
                client.send(JSON.stringify(message));
            }
        }
    }
}

module.exports = new WebSocketService();
