
  const parseElevenLabsTimestamps = (alignment) => {
    const sentences = [];
    let currentSentence = '';
    let startTimestamp = alignment.character_start_times_seconds[0];
    let endTimestamp = alignment.character_end_times_seconds[0];
  
    for (let i = 0; i < alignment.characters.length; i++) {
      const char = alignment.characters[i];
  
      // Add the character to the current sentence
      currentSentence += char;
  
      // Update the end timestamp for this character
      endTimestamp = alignment.character_end_times_seconds[i];
  
      // Check if we reached the end of a sentence
      if (char === '.' || char === '!' || char === '?') {
        // Add the sentence with its duration
        const duration = endTimestamp - startTimestamp;
        sentences.push({
          duration: parseFloat(duration.toFixed(2)),
          sentence: currentSentence.trim()
        });
  
        // Reset for the next sentence
        currentSentence = '';
        startTimestamp = alignment.character_start_times_seconds[i + 1] || endTimestamp;
      }
    }
  
    return sentences;
  }
  module.exports = {parseElevenLabsTimestamps};
  
  