const OpenAIService = require('./services/openaiService');

async function testModeration() {
  const text = "In a world scarred by conflict, behold the tale of the tiniest peacemaker—the child who ended World War 3. Amidst the turmoil, the mettle of humankind was tested, as nations battled fiercely, stirring an ashen whirlwind of despair.\n\nYet, in the thick of battlefields emerged a beacon of hope, an innocent soul that dared to dream-- a child called Hope. She was but seven, yet her spirit eclipsed her years. Touching the hearts of the world's most powerful - a little rose bent on peace.\n\nShe appealed to the world, her tender voice resonating over the noise of cannons. \"We are all keepers of this planet. What legacy shall we leave for the children yet to come?\" she asked, her innocence piercing through hardened hearts.\n\nThis sparked a global ceasefire. Her voice echoed in soldiers' hearts, softened by a child's plea.  \"Let's restore our planet for the generations yet to come,\" her resonating message unshackled the chains of warfare.\n\nShe taught us that victory is not in conquest, but in coexistence. For the world to thrive, we need unity, understanding and kindness above power. A small voice caused a seismic shift in the world's landscape. Her name, her voice pushing us towards amity.\n\nBy the valor of a seven-year-old, the World War 3 came to a halt. A tale to be etched into the annals of history. Remember the child, remember the peace. Let's build a legacy worthy of Hope..";

 try {
    const { highScores, isNotModerate} = await OpenAIService.moderateText(text);

    if (isNotModerate) {
      console.log('Moderation Status: ❌ Not Moderate');
    } else {
      console.log('Moderation Status: ✅ Safe');
    }
    console.log(isNotModerate, highScores)

  } catch (error) {
    console.error('Error:', error.message);
  }
}

testModeration();
