'use strict';
module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('videos', {
      id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      jobId: {
        type: Sequelize.STRING,
        allowNull: false,
        unique: true,
      },
      userId: {
        type: Sequelize.INTEGER,
        allowNull: false,
        references: {
          model: 'users',
          key: 'id',
        },
      },
      videoPath: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      generationStatus: {
        type: Sequelize.STRING,
        defaultValue: 'pending',
      },
      platform: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      isPostSuccessful: {
        type: Sequelize.BOOLEAN,
        defaultValue: false,
      },
      videoType: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      voiceType: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      artStyle: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      aspectRatio: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      duration: {
        type: Sequelize.INTEGER,
        allowNull: true,
      },
      prompt: {
        type: Sequelize.TEXT,
        allowNull: false,
      },
      createdAt: {
        type: Sequelize.DATE,
        allowNull: false,
      },
      updatedAt: {
        type: Sequelize.DATE,
        allowNull: false,
      },
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('videos');
  }
};